﻿using System.IO;
using System.Windows;
using System.Windows.Controls;
using System.Xaml;

namespace XamlReadersAndWriters
{
    partial class Utils
    {
        // UWAGA: Poprawki właściwości obiektów Window, które można zastosować także do obiektów Page, można sprawdzić w wersji tej funkcji
        //       zrealizowanej w przykładzie XAMLPAD2009.
        public static object ConvertXmlStringToMorphedObjectGraph(string xmlString)
        {
            // String -> TextReader -> XamlXmlReader
            using (TextReader textReader = new StringReader(xmlString))
            using (XamlXmlReader reader = new XamlXmlReader(textReader,
            System.Windows.Markup.XamlReader.GetWpfSchemaContext()))
            using (XamlObjectWriter writer = new XamlObjectWriter(reader.SchemaContext))
            {
                // Pętla węzłowa
                while (reader.Read())
                {
                    // Pomiń zdarzenia oraz x:Class
                    if (reader.NodeType == XamlNodeType.StartMember &&
                    reader.Member.IsEvent || reader.Member == XamlLanguage.Class)
                    {
                        reader.Skip();
                    }
                    if (reader.NodeType == XamlNodeType.StartObject && reader.Type.UnderlyingType == typeof(Window))
                    {
                        // Przekształć obiekty Window na Page
                        writer.WriteStartObject(new XamlType(typeof(Page), reader.SchemaContext));
                    }
                    else
                    {
                        // W przeciwnym razie zapisz węzeł w niezmienionej postaci
                        writer.WriteNode(reader);
                    }
                }
                // Kiedy XamlObjectWriter skończy pracę, będzie to instancja obiektu głównego
                return writer.Result;
            }
        }
    }
}